using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using VIRP.AHOBPR.BO;

namespace VIRP.AHOBPR.DAL
{
	public partial class UPDATES_PROCESSED_NOTIFICATION_STATUSDB : VIRP.DBUtils
	{
		#region Fields
		#endregion

		#region Constructors

		public UPDATES_PROCESSED_NOTIFICATION_STATUSDB()
		{
		}

		#endregion

		#region Properties
		#endregion

		#region Methods

		public UPDATES_PROCESSED_NOTIFICATION_STATUS GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int64 UPDATES_PROCESSED_NOTIFICATION_STATUS_ID)
		{
			UPDATES_PROCESSED_NOTIFICATION_STATUS objReturn = null;

			try
			{
				using (AHOBPRDBDataContext dbContext = GetAHOBPRDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_UPDATES_PROCESSED_NOTIFICATION_STATUS_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, UPDATES_PROCESSED_NOTIFICATION_STATUS_ID).FirstOrDefault();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public List<UPDATES_PROCESSED_NOTIFICATION_STATUS> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
		{
			List<UPDATES_PROCESSED_NOTIFICATION_STATUS> objReturn = null;

			try
			{
				using (AHOBPRDBDataContext dbContext = GetAHOBPRDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_UPDATES_PROCESSED_NOTIFICATION_STATUS_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public Int64 Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, UPDATES_PROCESSED_NOTIFICATION_STATUS objSave)
		{
			Int64? objReturn = objSave.UPDATES_PROCESSED_NOTIFICATION_STATUS_ID;

			try
			{
				using (AHOBPRDBDataContext dbContext = GetAHOBPRDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_UPDATES_PROCESSED_NOTIFICATION_STATUS_save(CURRENT_USER, CURRENT_REGISTRY_ID, DateTime.Now, objSave.CREATEDBY, objSave.EDIPI, objSave.PROCESS_ERROR, objSave.PROCESS_NAME, objSave.PROCESS_STATUS, objSave.REGISTRANT_ID, DateTime.Now, objSave.UPDATEDBY, objSave.UPDATES_BENS_REGISTRANT_NOTIFICATION_ID, ref objReturn);
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn.GetValueOrDefault();
		}

		public Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int64 UPDATES_PROCESSED_NOTIFICATION_STATUS_ID)
		{
			Boolean objReturn = false;

			try
			{
				using (AHOBPRDBDataContext dbContext = GetAHOBPRDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_UPDATES_PROCESSED_NOTIFICATION_STATUS_delete(CURRENT_USER, CURRENT_REGISTRY_ID, UPDATES_PROCESSED_NOTIFICATION_STATUS_ID);
					objReturn = true;
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		#endregion
	}
}
